/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import java.io.File;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.testsuite.TestBase;

public class TestFreeFormPortIdentifiers
extends TestBase {
    public static void testMissingPortInCommPortIdentifier() throws Exception {
        TestFreeFormPortIdentifiers.begin("TestMissingPort");
        try {
            CommPortIdentifier.getPortIdentifier("blablub");
            TestFreeFormPortIdentifiers.fail("Got an identifier for non-exisiting path", new Object[0]);
        }
        catch (NoSuchPortException noSuchPortException) {
            // empty catch block
        }
        TestFreeFormPortIdentifiers.finishedOK();
    }

    public static void testDevicePathInCommPortIdentifier() throws Exception {
        TestFreeFormPortIdentifiers.begin("TestDevicePath ");
        try {
            CommPortIdentifier.getPortIdentifier(TestFreeFormPortIdentifiers.getPortName());
        }
        catch (NoSuchPortException nspe) {
            TestFreeFormPortIdentifiers.fail("Couldn't obtain identifier for device path", new Object[0]);
        }
        TestFreeFormPortIdentifiers.finishedOK();
    }

    public static void testDevicePathToInvalidTTYInCommPortIdentifier() throws Exception {
        TestFreeFormPortIdentifiers.begin("TestDevicePathToInvalidTTY");
        File tempFile = File.createTempFile("pjc", null);
        tempFile.deleteOnExit();
        try {
            CommPortIdentifier.getPortIdentifier(tempFile.getAbsolutePath());
            TestFreeFormPortIdentifiers.fail("Got an identifier for an invalid device", new Object[0]);
        }
        catch (NoSuchPortException noSuchPortException) {
            // empty catch block
        }
        TestFreeFormPortIdentifiers.finishedOK();
    }
}

